<?php
  BIndex::Add('typos', 'file');

  BEvent::HookInstanceOf('TyposFileIndex', 'BannerToFooter', 'post footer');
  BEvent::HookInstanceOf('TyposFileIndex', 'BannerToFooter', 'posts footer');
  BEvent::HookInstanceOf('TyposFileIndex', 'AddHeadScriptTo', 'on tpl vars: common');

  BConfig::$strings += array(
    'spell reporter: email subject' => 'Misspelling reported - $siteName',

    'spell reporter: banner' => 'Let\'s keep our language clean together &ndash; press'.
                                ' <strong>Ctrl+Enter</strong> on mistake!',
    'spell reporter: help' => 'Ctrl+Enter - Spell Reporting\n\n'.
                              'With this key combination you can send typos and errors in'.
                              ' text for us to correct.\nTo do so first select a fragment containing'.
                              ' a mistake with your mouse and then press Ctrl+Enter.\n\n'.
                              ' Reporting is 100% anonymous.',
    'spell reporter: prompt 1' => 'This fragment is about to be reported (you\'ll remain on this page):',
    'spell reporter: prompt 2' => 'You can enter a comment to clarify the mistake if you would like to:',
    'spell reporter: submit' => 'Report',
    'spell reporter: cancel' => 'Cancel',
    'spell reporter: thanks' => 'Thanks for your feedback!',
    'spell reporter: failure' => 'Hmm... something didn\'t work out (or you have a slow'.
                                 ' connection). Open a new window with more information?'
  );

/* one-shot */
  $this->name = 'spell reporter';
  $this->Caption('Опечатки', 'ru');
  $this->info['user files'] = array('TyposFileIndex', 'UserFiles');

/* install TyposFileIndex */
class TyposFileIndex extends BaseHashOfArraysFileIndex {
  // 90%-transparent white pixel.
  const BackgroundImage = 'iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAFklEQVR4XgXAAQkAAADCMPsHfY3J0AEJ4gPks9bT/AAAAABJRU5ErkJggg==';
  public $indexName = 'typos';

  function BannerToFooter(&$footer, $post) { $footer[] = Translate('spell reporter: banner'); }

  static function AddHeadScriptTo(&$vars) {
    $str = '';
    foreach (array('help', 'thanks', 'failure') as $name) {
      $str .= "$name: \"".addcslashes( Translate('spell reporter: '.$name), "\"" ).'", ';
    }
    $str = substr($str, 0, -2);

    $bk = 'data:image/png;base64,'.self::BackgroundImage;
    $scriptURL = BConfig::$staticURL.'spellreporter.js';
    // using head's header so that styles can be overriden by linked styles thereafter.
    $vars['headHeader'] .= <<<HEAD
<style type="text/css">
  #spellReport { position: fixed; -position: absolute; display: none; z-index: 500; background: repeat url($bk); -background: white; padding: 1em; overflow: auto; }
  #spellReport table { width: 40em; height: 12em; border-collapse: collapse; }
  #spellReport td { vertical-align: middle; }
  #spellReport p, blockquote { margin: 0; padding: 0; background: transparent; text-align: left; color: black; }
  #spellReport input { display: block; width: 90%; margin: 0.4em auto 1.2em auto; }
  #spellReport blockquote { font-style: italic; margin: 0.8em 0 1em 0; text-align: center; }
  #spellReport blockquote strong { color: red; font-weight: normal; }
  #spellReport div { text-align: center; }
  #spellReport button { cursor: pointer; font-size: 1.1em; font-weight: bold; margin: 0 5px; }
  #spellReport button + button { font-weight: normal; }
</style>
<script type="text/javascript">window.spellrep = {{$str}};</script>
<script type="text/javascript" src="$scriptURL"></script>
HEAD;

    $vars['bodyHeader'] .=
      '<div id="spellReport"><table><tr><td>'.
        '<p>'.Translate('spell reporter: prompt 1').'</p>'.
        '<blockquote></blockquote>'.
        '<p> <strong>'.Translate('spell reporter: prompt 2').'</strong> </p>'.
        '<input type="text" onkeydown="if (event.keyCode == 13) { this.nextSibling.firstChild.click(); }" />'.
        '<div><button onclick="SubmitSpellReport(false);">'.Translate('spell reporter: submit').'</button>'.
        '<button onclick="SubmitSpellReport(true);">'.Translate('spell reporter: cancel').'</button></div>'.
      '</td></tr></table></div>';
  }

  static function UserFiles() { return self::FileOf(SingleInstanceOf(__CLASS__)->indexName); }
}

/* one-shot */
return;
?>

/* Full version of spellreporter.js */

var old = document.onkeypress;
document.onkeypress = function (e) {
  if (e = window.event || e) {
    var key = e.which ? e.which : e.keyCode;
        key = e.keyCode == 10 ? 13 : e.keyCode;
    var ctrl = e.ctrlKey || e.modifiers == 2;

    if ( (key == 13 && ctrl) || (key == 0 && e.charCode == 106 && ctrl) ) {
      PopUpSpellReporter();
      return false;
    }
  }

  if (typeof old == 'function') { old(e); }
}

function PopUpSpellReporter() {
  var selection;
  if (window.getSelection) {
    selection = window.getSelection();
  } else if (document.getSelection) {
    selection = document.getSelection();
  } else {
    selection = document.selection;
  }

  var typo;
  if (selection) {
    if (selection.getRangeAt) {
      typo = selection.rangeCount > 0 ? selection.getRangeAt(0) : null;
    } else if (selection.createRange) {
      typo = selection.createRange();
      if (typo.text == '') { typo = null; }
    }
  }

  var typoStr = (typo || '').toString ? typo.toString() : typo.text;

  if (typoStr) {
    ShowSpellReport(GetTextAround(typo), typoStr);
  } else {
    alert(window.spellrep.help);
  }
}

  function GetTextAround(range) {
    function Clean(str) {
      return str.replace(/^\s+/, '').replace(/\s+$/, '').replace(/(\s){2,}/g, '$1');
    }

      var max = 50;
      var distance = 100;

    var result = '';

    var str = range.toString ? range.toString() : range.text;
        str = Clean(str).substr(0, max);

    if (range.startContainer) {  // Firefox
      result = str;

      if (range.startContainer.nodeType == 3) {
        var fragment = range.startContainer.nodeValue.substr(Math.max(0, range.startOffset - distance),
                                                             distance * 2 + str.length);
        if (fragment.length > 0) {
          result = range.startOffset - distance > 0 ? '…' : '';
          result += fragment;
        }
      }
    } else {                    // Internet Explorer
      if (range.text.length > max) { range.moveEnd('character', max - range.text.length); }

      range.moveStart('character', -distance);
      range.moveEnd('character', distance);
      result = '…' + range.text.replace(/\n/g, '<br />') + '…';
    }

    result = Clean(result);

    if (result != str) {
      var quoteRegExp = new RegExp('(\\' + '.*+?^$|()[]{}\\'.split('').join('|\\') + ')', 'g');
      var quoted = str.replace(quoteRegExp, '\\$1');
      result = result.replace(new RegExp(quoted, 'g'), '<strong>' + str + '</strong>');
    }

    return result;
  }

  function ShowSpellReport(fragment, typo) {
    if (!window.spellrep.form) {
      window.spellrep.form = document.getElementById('spellReport');

      var firstElem = window.spellrep.form.firstChild;
      while (firstElem && firstElem.tagName.toLowerCase() != 'td') { firstElem = firstElem.firstChild; }
      window.spellrep.firstElem = firstElem.firstChild;
    }

    var first = window.spellrep.firstElem;
        first.nextSibling.innerHTML = '«' + fragment + '»';

    window.spellrep.fragment = fragment;
    window.spellrep.typo = typo;

    var form = window.spellrep.form;
        form.style.display = 'block';
        form.style.left = Math.round((WindowWidth() - WidthOf(form)) / 2) + 'px';

        var top = Math.round((WindowHeight() - HeightOf(form)) / 2);
        if (false /*@cc_on || @_jscript_version < 5.7 @*/) {
          // IE 6 check, got from http://www.thefutureoftheweb.com/blog/detect-ie6-in-javascript.
          top += document.documentElement.scrollTop;
        }
        form.style.top = top + 'px';

    first.nextSibling.nextSibling.nextSibling.select();
    first.nextSibling.nextSibling.nextSibling.focus();
  }

    function SubmitSpellReport(cancel) {
      window.spellrep.form.style.display = 'none';

      if (!cancel) {
        var comment = window.spellrep.firstElem.nextSibling.nextSibling.nextSibling.value;

        window.spellrep.url = window.engineURL + 'typo.php'
          + '?page=' + encodeURIComponent(location.href)
          + '&fragment=' + encodeURIComponent(window.spellrep.fragment)
          + '&typo=' + encodeURIComponent(window.spellrep.typo)
          + '&comment=' + encodeURIComponent(comment);

        var req = new ScriptRequest(window.spellrep.url + '&js=', SpellReported);
            req.on_request_failure = SpellReportingFailed;
            req.Perform();
      }
    }

function SpellReported(status) {
  if (status == 'ok') {
    alert(window.spellrep.thanks);
    return true;
  }
}

function SpellReportingFailed() {
  if (confirm(window.spellrep.failure)) {
    window.open(window.spellrep.url, '_blank');
  }
}

// got from http://www.howtocreate.co.uk/tutorials/javascript/browserwindow
function WindowWidth() {
  if (IsNum(window.innerWidth)) {  // Non-IE
    return window.innerWidth;
  } else if (document.documentElement && IsNum(document.documentElement.clientWidth)) {
    // IE 6+ in 'standards compliant mode'
    return document.documentElement.clientWidth;
  } else if (document.body) {       // IE 4 compatible
    return document.body.clientWidth;
  }
}

// got from http://www.howtocreate.co.uk/tutorials/javascript/browserwindow
function WindowHeight() {
  if (IsNum(window.innerHeight)) {  // Non-IE
    return window.innerHeight;
  } else if (document.documentElement && IsNum(document.documentElement.clientHeight)) {
    // IE 6+ in 'standards compliant mode'
    return document.documentElement.clientHeight;
  } else if (document.body) {        // IE 4 compatible
    return document.body.clientHeight;
  }
}

function HeightOf(element, newHeight) {
    element = $(element);

  if (IsNum(newHeight)) {
    return parseInt( $style(element, 'height', Math.round(newHeight) + 'px') );
  } else {
    if (IsNum(element.offsetHeight)) {
      var extra = parseInt( $style(element, 'borderTopWidth') )
                  + parseInt( $style(element, 'borderBottomWidth') );
      return IsNum(extra) ? element.offsetHeight - extra : element.offsetHeight;
    } else {
      return parseInt( $style(element, 'height') );
    }
  }
}

function WidthOf(element, newWidth) {
    element = $(element);

  if (IsNum(newWidth)) {
    return parseInt( $style(element, 'width', Math.round(newWidth) + 'px') );
  } else {
    if (IsNum(element.offsetWidth)) {
      var extra = parseInt( $style(element, 'borderLeftWidth') )
                  + parseInt( $style(element, 'borderRightWidth') );
      return IsNum(extra) ? element.offsetWidth - extra : element.offsetWidth;
    } else {
      return parseInt( $style(element, 'width') );
    }
  }
}

/* ScriptRequest */

function ScriptRequest(url, on_receive) {
  this.timeout = 5000;

  this.cancelled = true;
  this.url = url;
  this.js_param_prefix = '&js=';
  this.post_data = null;
  this.navigate_on_failure = false;
  this.on_receive = on_receive;
  this.on_end = function () { }
  this.on_request_failure = function () { }

  this.timer = null;
  this.object_index = null;
  this.callback_name = null;

  this.Perform = function () {
    this.cancelled = false;

    var prefix = this.navigate_on_failure ? this.js_param_prefix : '';
    var url = this.url + prefix + encodeURIComponent(this.callback_name);
    this.xhrObject = RequestScript(url, this.post_data);

    var self = this;
    this.timer = setTimeout(function () { self.RequestFailed(); }, this.timeout);
  }

  this.Callback = function () {
    if (!this.cancelled) {
      this.End();

      var args = this.ArgumentsToArray(arguments);

      if (args.length) {
        if (!this.on_receive.apply(this, args)) {
          args = [];
        }
      }

      if (!args.length) {
        this.RequestFailed();
      }
    }
  }

    this.ArgumentsToArray = function (argsObject) {
      return Array.prototype.slice.call(argsObject);
    }

  this.RequestFailed = function () {
    this.End();
    if (this.navigate_on_failure) {
      location.href = this.url;
    }
    this.call_back(this.on_request_failure);
  }

  this.End = function () {
    this.cancelled = true;
    clearTimeout(this.timer);

    if (typeof this.xhrObject == 'object' && this.xhrObject &&
        typeof this.xhrObject.abort == 'function') {
      this.xhrObject.abort();
    }

    this.call_back(this.on_end);
  }

  this.call_back = function (func) {
    if (typeof func == 'function') {
      func.apply(this);
    }
  }

  this.AssignTempObject = function () {
    if (!isset(window.temp_script_request_objects)) {
      window.temp_script_request_objects = [];
    }

    this.object_index = window.temp_script_request_objects.push(this) - 1;
    this.callback_name =
      'window.temp_script_request_objects[' + this.object_index + '].Callback';
  }

  this.AssignTempObject();
}

function RequestScript(url, data) {
  var request = CreateXHRequest();
  if (request) {
    var method = data ? 'POST' : 'GET';
    request.open(method, url, true);
    request.onreadystatechange = function () {
      if (request.readyState == 4 && (request.status == 200 || request.status == 304 /*not modified*/)) {
        eval(request.responseText);
      }
    }

    if (isset(data)) {
      request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
      request.setRequestHeader('Content-Length', data.length);
    }

    request.send(data);
  } else {
    var span = document.createElement('SPAN');
        span.style.display = 'none';

    if (isset(data)) {
      if (url.indexOf('?') == -1) {
        url += '?';
      }
      url += '&' + data;
    }

    span.innerHTML = 'IE workaround. ' +
                     '<sc'+'ript type="text/javascript" src="' + url + '">i-e</scri'+'pt>';

    document.body.appendChild(span);
  }

  return request;
}

function CreateXHRequest() {
  var request;

  try {
    request = new XMLHttpRequest();
  } catch (e) {
    var activex = new Array("MSXML2.XMLHTTP.6.0",
                            "MSXML2.XMLHTTP.5.0",
                            "MSXML2.XMLHTTP.4.0",
                            "MSXML2.XMLHTTP.3.0",
                            "MSXML2.XMLHTTP",
                            "Microsoft.XMLHTTP");

    for (var i = 0; i < activex.length && !request; i++) {
      try {
        request = new ActiveXObject(activex[i]);
      } catch (e) {}
    }
  }

  return request ? request : null;
}

/* install static/spellreporter.js */
var old=document.onkeypress;document.onkeypress=function(c){if(c=window.event||c){var a=c.which?c.which:c.keyCode;a=c.keyCode==10?13:c.keyCode;var b=c.ctrlKey||c.modifiers==2;if((a==13&&b)||(a==0&&c.charCode==106&&b)){PopUpSpellReporter();return false}}if(typeof old=="function"){old(c)}};function PopUpSpellReporter(){var b;if(window.getSelection){b=window.getSelection()}else{if(document.getSelection){b=document.getSelection()}else{b=document.selection}}var c;if(b){if(b.getRangeAt){c=b.rangeCount>0?b.getRangeAt(0):null}else{if(b.createRange){c=b.createRange();if(c.text==""){c=null}}}}var a=(c||"").toString?c.toString():c.text;if(a){ShowSpellReport(GetTextAround(c),a)}else{alert(window.spellrep.help)}}function GetTextAround(e){function d(j){return j.replace(/^\s+/,"").replace(/\s+$/,"").replace(/(\s){2,}/g,"$1")}var h=50;var a=100;var i="";var g=e.toString?e.toString():e.text;g=d(g).substr(0,h);if(e.startContainer){i=g;if(e.startContainer.nodeType==3){var f=e.startContainer.nodeValue.substr(Math.max(0,e.startOffset-a),a*2+g.length);if(f.length>0){i=e.startOffset-a>0?"…":"";i+=f}}}else{if(e.text.length>h){e.moveEnd("character",h-e.text.length)}e.moveStart("character",-a);e.moveEnd("character",a);i="…"+e.text.replace(/\n/g,"<br />")+"…"}i=d(i);if(i!=g){var c=new RegExp("(\\"+".*+?^$|()[]{}\\".split("").join("|\\")+")","g");var b=g.replace(c,"\\$1");i=i.replace(new RegExp(b,"g"),"<strong>"+g+"</strong>")}return i}function ShowSpellReport(fragment,typo){if(!window.spellrep.form){window.spellrep.form=document.getElementById("spellReport");var firstElem=window.spellrep.form.firstChild;while(firstElem&&firstElem.tagName.toLowerCase()!="td"){firstElem=firstElem.firstChild}window.spellrep.firstElem=firstElem.firstChild}var first=window.spellrep.firstElem;first.nextSibling.innerHTML="«"+fragment+"»";window.spellrep.fragment=fragment;window.spellrep.typo=typo;var form=window.spellrep.form;form.style.display="block";form.style.left=Math.round((WindowWidth()-WidthOf(form))/2)+"px";var top=Math.round((WindowHeight()-HeightOf(form))/2);if(false
/*@cc_on || @_jscript_version < 5.7 @*/
){top+=document.documentElement.scrollTop}form.style.top=top+"px";first.nextSibling.nextSibling.nextSibling.select();first.nextSibling.nextSibling.nextSibling.focus()}function SubmitSpellReport(b){window.spellrep.form.style.display="none";if(!b){var c=window.spellrep.firstElem.nextSibling.nextSibling.nextSibling.value;window.spellrep.url=window.engineURL+"typo.php?page="+encodeURIComponent(location.href)+"&fragment="+encodeURIComponent(window.spellrep.fragment)+"&typo="+encodeURIComponent(window.spellrep.typo)+"&comment="+encodeURIComponent(c);var a=new ScriptRequest(window.spellrep.url+"&js=",SpellReported);a.on_request_failure=SpellReportingFailed;a.Perform()}}function SpellReported(a){if(a=="ok"){alert(window.spellrep.thanks);return true}}function SpellReportingFailed(){if(confirm(window.spellrep.failure)){window.open(window.spellrep.url,"_blank")}}function WindowWidth(){if(IsNum(window.innerWidth)){return window.innerWidth}else{if(document.documentElement&&IsNum(document.documentElement.clientWidth)){return document.documentElement.clientWidth}else{if(document.body){return document.body.clientWidth}}}}function WindowHeight(){if(IsNum(window.innerHeight)){return window.innerHeight}else{if(document.documentElement&&IsNum(document.documentElement.clientHeight)){return document.documentElement.clientHeight}else{if(document.body){return document.body.clientHeight}}}}function HeightOf(c,b){c=$(c);if(IsNum(b)){return parseInt($style(c,"height",Math.round(b)+"px"))}else{if(IsNum(c.offsetHeight)){var a=parseInt($style(c,"borderTopWidth"))+parseInt($style(c,"borderBottomWidth"));return IsNum(a)?c.offsetHeight-a:c.offsetHeight}else{return parseInt($style(c,"height"))}}}function WidthOf(b,c){b=$(b);if(IsNum(c)){return parseInt($style(b,"width",Math.round(c)+"px"))}else{if(IsNum(b.offsetWidth)){var a=parseInt($style(b,"borderLeftWidth"))+parseInt($style(b,"borderRightWidth"));return IsNum(a)?b.offsetWidth-a:b.offsetWidth}else{return parseInt($style(b,"width"))}}}function ScriptRequest(a,b){this.timeout=5000;this.cancelled=true;this.url=a;this.js_param_prefix="&js=";this.post_data=null;this.navigate_on_failure=false;this.on_receive=b;this.on_end=function(){};this.on_request_failure=function(){};this.timer=null;this.object_index=null;this.callback_name=null;this.Perform=function(){this.cancelled=false;var e=this.navigate_on_failure?this.js_param_prefix:"";var d=this.url+e+encodeURIComponent(this.callback_name);this.xhrObject=RequestScript(d,this.post_data);var c=this;this.timer=setTimeout(function(){c.RequestFailed()},this.timeout)};this.Callback=function(){if(!this.cancelled){this.End();var c=this.ArgumentsToArray(arguments);if(c.length){if(!this.on_receive.apply(this,c)){c=[]}}if(!c.length){this.RequestFailed()}}};this.ArgumentsToArray=function(c){return Array.prototype.slice.call(c)};this.RequestFailed=function(){this.End();if(this.navigate_on_failure){location.href=this.url}this.call_back(this.on_request_failure)};this.End=function(){this.cancelled=true;clearTimeout(this.timer);if(typeof this.xhrObject=="object"&&this.xhrObject&&typeof this.xhrObject.abort=="function"){this.xhrObject.abort()}this.call_back(this.on_end)};this.call_back=function(c){if(typeof c=="function"){c.apply(this)}};this.AssignTempObject=function(){if(!isset(window.temp_script_request_objects)){window.temp_script_request_objects=[]}this.object_index=window.temp_script_request_objects.push(this)-1;this.callback_name="window.temp_script_request_objects["+this.object_index+"].Callback"};this.AssignTempObject()}function RequestScript(url,data){var request=CreateXHRequest();if(request){var method=data?"POST":"GET";request.open(method,url,true);request.onreadystatechange=function(){if(request.readyState==4&&(request.status==200||request.status==304)){eval(request.responseText)}};if(isset(data)){request.setRequestHeader("Content-Type","application/x-www-form-urlencoded");request.setRequestHeader("Content-Length",data.length)}request.send(data)}else{var span=document.createElement("SPAN");span.style.display="none";if(isset(data)){if(url.indexOf("?")==-1){url+="?"}url+="&"+data}span.innerHTML='IE workaround. <script type="text/javascript" src="'+url+'">i-e<\/script>';document.body.appendChild(span)}return request}function CreateXHRequest(){var c;try{c=new XMLHttpRequest()}catch(d){var a=new Array("MSXML2.XMLHTTP.6.0","MSXML2.XMLHTTP.5.0","MSXML2.XMLHTTP.4.0","MSXML2.XMLHTTP.3.0","MSXML2.XMLHTTP","Microsoft.XMLHTTP");for(var b=0;b<a.length&&!c;b++){try{c=new ActiveXObject(a[b])}catch(d){}}}return c?c:null};

/* install config/templates/email - spell report.wiki */
Hello **$recepientName**,

Someone with IP ((http://www.maxmind.com/app/locate_demo_ip?ips=$ip==$ip)) has reported a mistake on **$siteName** on page (($pageURL==%%$pageURL%%)) on //$time//:
##(message)
  $typo
##

Text nearby:
##(message)
  $fragment
##

{?$
Reporter's commentary:
%%
  $comment
%%
$?}

/* install typo.php */
<?php
  require 'engine/page.php';

  $pageURL = $_REQUEST['page'];
  $fragment = trim( $_REQUEST['fragment'] );
  $typo = trim( $_REQUEST['typo'] );
  $comment = trim( $_REQUEST['comment'] );
  if (!$pageURL or $fragment === '') {
    throw new BException('No "page" or "fragment" parameters passed.');
  }

  $ip = $_SERVER['REMOTE_ADDR'];
  $time = DateFmt::Format('[D__, d#my]AT h##m');
  $fragment = strtr($fragment, array('<strong>' => '**', '</strong>' => '**'));

  $vars = compact('ip', 'time', 'pageURL', 'typo', 'fragment', 'comment');
  $subject = Template::LiteFormat( Translate('spell reporter: email subject') );
  NotifyOf('spell report', $subject, $vars);

  $time = time();
  BIndex::AddTo('typos', $pageURL, compact('time', 'fragment', 'typo', 'comment', 'ip'));

  if ($func = &$_REQUEST['js']) {
    echo $func.'("ok");';
  } else {
    echo '<em>Thanks for reporting this mistake.</em>';
  }
